<?php

namespace App\Models;

class OutRequest extends Eloquent {

	protected $table = 'out_requests';
	public $timestamps = true;
	protected $fillable = array('work_order_id', 'nokia_requester_id', 'entity_id', 'user_id', 'stream_id', 'notes', 'site_id', 'subcontractor_id', 'internal_supplier_id', 'site_engineer_id');

	public function site_engineer()
	{
		return $this->belongsTo('App\Models\SiteEngineer');
	}

	public function nokia_requester()
	{
		return $this->belongsTo('App\Models\NokiaRequester');
	}

	public function internal_supplier()
	{
		return $this->belongsTo('App\Models\InternalSupplier');
	}

	public function subcontractor()
	{
		return $this->belongsTo('App\Models\Subcontractor');
	}

	public function entity()
	{
		return $this->belongsTo('App\Models\Entity');
	}

	public function user()
	{
		return $this->belongsTo('App\User');
	}

	public function stream()
	{
		return $this->belongsTo('App\Models\Stream');
	}

	public function items()
	{
		return $this->morphToMany('App\Models\Item', 'itemable');
	}

}