<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('location_group_id')->unsigned();
			$table->enum('currency', array('GBP', 'EUR'));
			$table->string('name', 55);
			$table->string('stopAutoRebook', 55);
			$table->string('name_number', 55);
			$table->string('street', 55);
			$table->string('city', 55);
			$table->string('city_plus_search', 55)->nullable();
			$table->string('country', 55);
			$table->string('post_code', 55);
			$table->string('address', 55)->nullable();
			$table->string('active', 55);
			$table->string('display', 55);
			$table->string('check_man', 55);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}