<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChauffeursTable extends Migration {

	public function up()
	{
		Schema::create('chauffeurs', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('type_chauffeur_id')->unsigned();
			$table->bigInteger('mon_bedou_id')->unsigned();
			$table->string('photo', 255);
			$table->text('nom_chauffeur');
			$table->text('prenom_chauffeur');
			$table->string('lieu_habitation');
			$table->string('contact_chauffeur');
			$table->string('permis')->unique();
			$table->string('cni', 100)->unique();
			$table->string('password');
			$table->float('latittude', 8,12);
			$table->float('longitude', 8,12);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('chauffeurs');
	}
}