<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVehiculesTable extends Migration {

	public function up()
	{
		Schema::create('vehicules', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('modele_id')->unsigned();
			$table->bigInteger('chauffeur_id')->unsigned();
			$table->integer('type_vehicule_id')->unsigned();
			$table->string('immatriculation')->unique();
			$table->string('couleur');
			$table->string('numero_vente_technique')->unique();
			$table->date('date_delivrance');
			$table->date('date_expiration');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('vehicules');
	}
}