<?php

namespace App\Models\ZoneSpecifique;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ZoneSpecifique extends Eloquent {

	protected $table = 'zone_specifiques';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function prise_en_charge()
	{
		return $this->belongsTo('App\Models\PriseEnCharge\PriseEnCharge');
	}

	public function vehicule_zones()
	{
		return $this->hasMany('App\Models\VehiculeZone\VehiculeZone');
	}

}