<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->string('username')->index();
			$table->string('email')->index();
			$table->string('name')->nullable();
			$table->text('bio')->nullable();
			$table->string('avatar')->nullable();
			$table->string('website')->nullable();
			$table->json('profiles')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}