<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobsTable extends Migration {

	public function up()
	{
		Schema::create('jobs', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('title', 255);
			$table->text('description');
			$table->date('from');
			$table->date('to')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('jobs');
	}
}