<?php

namespace App;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('auth_id', 'firstname', 'lastname', 'gender', 'mail', 'phone');

	public function gadz()
	{
		return $this->hasOne('Gadz', 'user_id');
	}

	public function cursus()
	{
		return $this->belongsToMany('Cursus', 'user_cursus', 'user_id', 'cursus_id');
	}

	public function jobs()
	{
		return $this->hasMany('Job', 'user_id');
	}

	public function tbk()
	{
		return $this->hasManyThrough('Campus', 'Gadz');
	}

	public function resams()
	{
		return $this->belongsToMany('Resam', 'user_resam');
	}

	public function addresses()
	{
		return $this->hasMany('Address', 'user_id');
	}

	public function social()
	{
		return $this->belongsToMany('Social', 'user_social', 'user_id', 'social_id');
	}

	public function bouls()
	{
		return $this->hasMany('Bouls', 'user_id');
	}

	public function tags()
	{
		return $this->hasOne('Tags', 'user_id');
	}

	public function degrees()
	{
		return $this->hasMany('Degree', 'user_id');
	}

}