<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommissionsTable extends Migration {

	public function up()
	{
		Schema::create('commissions', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 50);
			$table->timestamps();
			$table->softDeletes();
			$table->enum('type', array('dollar', 'percent'));
			$table->binary('stores');
			$table->binary('roles');
			$table->string('model', 50)->nullable();
			$table->string('model_id', 50)->nullable();
			$table->string('title', 144)->nullable();
			$table->string('description', 255)->nullable();
			$table->float('amount', 8,2)->nullable();
			$table->timeTz('start')->nullable();
			$table->timestampTz('end')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('commissions');
	}
}