<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('first_name', 'middle_name', 'last_name', 'suffix', 'preferred_name', 'email', 'designation_id', 'profile_picture', 'mobile', 'ssn', 'dob', 'status');
    protected $visible = array('first_name', 'middle_name', 'last_name', 'suffix', 'preferred_name', 'email', 'designation_id', 'profile_picture', 'mobile', 'ssn', 'dob', 'status');

    public function designation()
    {
        return $this->hasOne('App\Models\Tenants\Designation', 'designation_id');
    }

}