<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('description', 255);
			$table->string('location', 255);
			$table->decimal('longitude');
			$table->decimal('latitude');
			$table->string('phone');
			$table->integer('service_id');
			$table->datetime('start_time')->nullable();
			$table->datetime('end_time')->nullable();
			$table->enum('status', array(''pending'', ''rejected'', ''active'', ''deactivate''));
			$table->string('phone_delivery')->nullable();
			$table->decimal('cost')->nullable();
			$table->enum('type', array(''delivery_request'', ''shipping_goods''));
			$table->integer('client_id');
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}