<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'phone', 'city_id', 'pin_code', 'pin_code_date_expired');
	protected $hidden = array('password');

	public function city()
	{
		return $this->belongsTo('App\Models\City');
	}

	public function orders()
	{
		return $this->hasMany('App\Models\Order');
	}

	public function token()
	{
		return $this->belongsTo('App\Models\Token');
	}

}