<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Testimonial extends Model 
{

    protected $table = 'testimonials';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'title', 'testimonial', 'company_name', 'branch_id');

    public function branch()
    {
        return $this->belongsTo('Branch');
    }

}