<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactDetailsTable extends Migration {

	public function up()
	{
		Schema::create('contact-details', function(Blueprint $table) {
			$table->increments('id');
			$table->json('type');
			$table->json('value');
			$table->string('icon');
			$table->json('title');
			$table->integer('order');
			$table->integer('branch_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('contact-details');
	}
}