<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Address extends Eloquent {

	protected $table = 'address';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('addressable', 'address_name', 'address_line1', 'address_line2', 'building_number', 'floor_number', 'phone', 'postal_code', 'long', 'lat', 'land_mark', 'country_id', 'is_default', 'is_active');

	public function addressable()
	{
		return $this->morphTo();
	}

}