<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Lookup extends Eloquent {

	protected $table = 'lookups';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('parent_id', 'slug', 'title', 'is_active', 'is_editable');

	public function users()
	{
		return $this->belongsToMany('User');
	}

	public function massages()
	{
		return $this->belongsToMany('Massage');
	}

}