<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Massage extends Eloquent {

	protected $table = 'contact_us_massages';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'email', 'comment', 'branch_id', 'request_type');

	public function branch()
	{
		return $this->belongsTo('Branch');
	}

	public function lookup()
	{
		return $this->belongsTo('Lookup');
	}

}