<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('userid');
			$table->string('username', 256);
			$table->string('password', 256);
			$table->string('confirm', 256);
			$table->enum('type', array('staff', 'member'));
			$table->timestamp('last_login');
			$table->tinyInteger('active')->default('1');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}