<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAppointmentRequestTable extends Migration {

	public function up()
	{
		Schema::create('appointment_request', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('worker_id')->unsigned();
			$table->integer('company_id')->unsigned();
			$table->date('date')->nullable();
			$table->enum('approved', array('true', 'false'))->nullable();
			$table->enum('status', array('wait', 'close'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('appointment_request');
	}
}