<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->text('hiring_responsible')->nullable();
			$table->text('phone_responsible')->nullable();
			$table->text('mobile_responsible')->nullable();
			$table->text('transfers_responsible')->nullable();
			$table->date('establishment_data')->nullable();
			$table->text('company_field')->nullable();
			$table->text('details')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}