<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserSkillsTable extends Migration {

	public function up()
	{
		Schema::create('user_skills', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->string('title', 191)->nullable();
			$table->enum('level', array('junior', 'middle', 'experienced', 'undefined'))->nullable();
			$table->string('experience', 191)->nullable();
			$table->string('last_practice', 191)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('user_skills');
	}
}