<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateResumeSkillsTable extends Migration {

	public function up()
	{
		Schema::create('resume_skills', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 191)->nullable();
			$table->text('details')->nullable();
			$table->integer('resume_id')->unsigned();
			$table->date('from')->nullable();
			$table->date('to')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('resume_skills');
	}
}