<?php

namespace Consolidated_Demands;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Consolidated_Demands extends Model 
{

    protected $table = 'consolidated_demands';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function demands()
    {
        return $this->hasMany('Demands', 'id', 'fk_consolidated_demands_id');
    }

    public function bids()
    {
        return $this->hasMany('Bids', 'id', 'fk_consolidated_demands_id');
    }

}