<?php

namespace Crops;

use Illuminate\Database\Eloquent\Model;

class Crops extends Model 
{

    protected $table = 'crops';
    public $timestamps = true;

    public function varieties()
    {
        return $this->hasMany('Varieties', 'id', 'fk_crop_id');
    }

    public function crop_pricing()
    {
        return $this->hasOne('Crop_Pricing', 'id', 'fk_crop_id');
    }

    public function crop_production_model()
    {
        return $this->hasOne('Crop_Production', 'id', 'fk_crop_id');
    }

    public function crop_classes()
    {
        return $this->hasMany('Crop_Classes', 'id', 'fk_crop_classes_id');
    }

}