<?php

namespace App\Models;

class Subscription extends Eloquent {

	protected $table = 'subscriptions';
	public $timestamps = true;
	protected $fillable = array('client_id', 'software_serial', 'domain', 'price', 'agent_id', 'agent_percentage', 'net_price', 'payment_method', 'payment_status', 'payment_date', 'renew');

	public function agent()
	{
		return $this->belongsTo('App\Models\Agent');
	}

	public function client()
	{
		return $this->belongsTo('App\Models\Client');
	}

}