<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('stories', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('story_part', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('story_part', function(Blueprint $table) {
			$table->foreign('stories_id')->references('id')->on('stories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('stories', function(Blueprint $table) {
			$table->dropForeign('stories_user_id_foreign');
		});
		Schema::table('story_part', function(Blueprint $table) {
			$table->dropForeign('story_part_user_id_foreign');
		});
		Schema::table('story_part', function(Blueprint $table) {
			$table->dropForeign('story_part_stories_id_foreign');
		});
	}
}