<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHmoFormSafetyArrangementsTable extends Migration {

	public function up()
	{
		Schema::create('hmo_form_safety_arrangements', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('hmo_form_id')->unsigned();
			$table->boolean('fire_detection')->nullable();
			$table->boolean('control_panel')->nullable();
			$table->boolean('heat_detectors')->nullable();
			$table->boolean('smoke_detectors_in_rooms')->nullable();
			$table->boolean('room_smoke_detector_battery_powered')->nullable();
			$table->boolean('common_smoke_detector')->nullable();
			$table->boolean('common_smoke_detector_battery_powered')->nullable();
			$table->boolean('alarm_sounders')->nullable();
			$table->string('system_tested')->nullable();
			$table->boolean('fire_doors')->nullable();
			$table->enum('fire_blankets', array(''all'', ''shared'', ''none''));
			$table->boolean('safety_equipment_serviced')->nullable();
			$table->boolean('fire_safety_training_provided')->nullable();
			$table->text('training_details')->nullable();
			$table->boolean('fire_risk_assessment_carried_out')->nullable();
			$table->boolean('gas_appliances')->nullable();
			$table->boolean('gas_appliances_legal')->nullable();
			$table->boolean('gas_appliances_checked')->nullable();
			$table->boolean('plh_gas_appliances_decarlation')->nullable();
			$table->boolean('furniture_provided')->nullable();
			$table->boolean('furniture_complies')->nullable();
			$table->boolean('plh_furniture_declaration')->nullable();
			$table->boolean('electrical_appliances')->nullable();
			$table->boolean('electricals_pat_tested')->nullable();
			$table->boolean('plh_electricals_declaration')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('hmo_form_safety_arrangements');
	}
}