<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderTable extends Migration {

	public function up()
	{
		Schema::create('Order', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('order_num', 50);
			$table->date('receive_date');
			$table->date('return_date');
			$table->string('lat', 50);
			$table->string('lng', 50);
			$table->text('map_desc');
			$table->integer('car_id')->unsigned()->nullable();
			$table->integer('type');
			$table->integer('duration')->default('0');
			$table->double('daily_cost');
			$table->integer('status')->default('0');
			$table->double('admin_commission_ratio');
			$table->double('admin_commission');
			$table->double('vat_amount');
			$table->string('coupon', 50);
			$table->double('rent_amount');
			$table->double('total_price');
			$table->integer('pay_type');
			$table->integer('pay_status');
			$table->integer('branch_id')->unsigned()->nullable();
			$table->integer('user_id')->unsigned();
			$table->double('coupon_value');
		});
	}

	public function down()
	{
		Schema::drop('Order');
	}
}