<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCarsTable extends Migration {

	public function up()
	{
		Schema::create('cars', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('image', 150);
			$table->integer('car_type_id')->unsigned()->nullable();
			$table->integer('category_id')->unsigned();
			$table->string('vehicle_num', 100);
			$table->string('color', 100);
			$table->integer('car_model_id')->unsigned()->nullable();
			$table->integer('quantity')->default('0');
			$table->text('description');
			$table->double('daily_price');
			$table->double('monthly_price');
			$table->double('yearly_price');
			$table->string('manufacter_year', 50);
			$table->date('off_date');
			$table->morphs('addable');
			$table->string('name', 150);
		});
	}

	public function down()
	{
		Schema::drop('cars');
	}
}