<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIsinfosTable extends Migration {

	public function up()
	{
		Schema::create('isinfos', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('addr1');
			$table->string('addr2');
			$table->string('province');
			$table->string('zipcode', 15);
			$table->string('taxid', 20);
			$table->decimal('vat');
			$table->integer('vattype');
			$table->integer('comtype');
			$table->string('combrand');
			$table->string('tel');
			$table->string('fax');
			$table->string('logo');
			$table->string('ref1');
			$table->text('ref2');
			$table->text('posconf');
		});
	}

	public function down()
	{
		Schema::drop('isinfos');
	}
}