<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Users extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function roles()
	{
		return $this->belongsToMany('UsersRoles');
	}

	public function permissions()
	{
		return $this->belongsToMany('UsersPermissions');
	}

}