<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMedicalHistoriesTable extends Migration {

	public function up()
	{
		Schema::create('Medical_histories', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('profile_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->string('name', 255);
			$table->string('type', 255);
			$table->date('start_date');
			$table->date('end_date');
			$table->string('note', 255);
			$table->datetime('created_at');
			$table->datetime('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('Medical_histories');
	}
}