<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRecipesTable extends Migration {

	public function up()
	{
		Schema::create('recipes', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->nullable();
			$table->string('name', 255);
			$table->text('description');
			$table->string('time', 255);
			$table->integer('difficulty');
			$table->integer('serves');
			$table->timestamps();
			$table->string('slug', 255);
		});
	}

	public function down()
	{
		Schema::drop('recipes');
	}
}