<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanyInsurancesTable extends Migration {

	public function up()
	{
		Schema::create('company_insurances', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('Company_id')->unsigned();
			$table->integer('InsuredItem_id')->unsigned();
			$table->integer('InsuranceCompany_id')->unsigned();
			$table->string('InsurancePolicyNumber', 50);
			$table->string('ContractNumber', 50);
			$table->date('InsuranceStart');
			$table->date('InsuranceEnd');
			$table->string('ReportTerm', 20);
			$table->string('ContactPerson', 100);
			$table->string('TelephoneNumber', 30);
			$table->string('EMail', 255);
			$table->text('CompanyInsuranceRemark');
		});
	}

	public function down()
	{
		Schema::drop('company_insurances');
	}
}