<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('CompanyType_id')->references('id')->on('company_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('company_employees', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('company_employees', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('communications', function(Blueprint $table) {
			$table->foreign('CommunicationType_id')->references('id')->on('communication_types')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('company_employee_employments', function(Blueprint $table) {
			$table->foreign('CompanyEmployee_id')->references('id')->on('company_employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('company_employee_illnesses', function(Blueprint $table) {
			$table->foreign('CompanyEmployee_id')->references('id')->on('company_employees')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('company_employee_illnesses', function(Blueprint $table) {
			$table->foreign('CompanyEmployeeInsurance_id')->references('id')->on('company_employee_insurance')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('company_employee_illnesses', function(Blueprint $table) {
			$table->foreign('StatusIllness_id')->references('id')->on('status_illnesses')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('company_insurances', function(Blueprint $table) {
			$table->foreign('Company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('company_insurances', function(Blueprint $table) {
			$table->foreign('InsuredItem_id')->references('id')->on('insured_items')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('company_insurances', function(Blueprint $table) {
			$table->foreign('InsuranceCompany_id')->references('id')->on('insurance_companies')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('company_employee_insurance', function(Blueprint $table) {
			$table->foreign('CompanyInsurance_id')->references('id')->on('company_insurances')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('company_employee_insurance', function(Blueprint $table) {
			$table->foreign('CompanyEmployee_id')->references('id')->on('company_employees')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('Company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('ImportedByUser_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('ValidatedByUser_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('StatusInvoice_id')->references('id')->on('invoice_states')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('invoice_lines', function(Blueprint $table) {
			$table->foreign('Invoice_id')->references('id')->on('invoices')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice_lines', function(Blueprint $table) {
			$table->foreign('Declaration_id')->references('id')->on('declarations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice_lines', function(Blueprint $table) {
			$table->foreign('ValidatedByUser_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('declarations', function(Blueprint $table) {
			$table->foreign('InsuranceCompany_id')->references('id')->on('insurance_companies')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('declarations', function(Blueprint $table) {
			$table->foreign('ReleasedBy_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('declarations', function(Blueprint $table) {
			$table->foreign('ViewedBy_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('invoice_line_originals', function(Blueprint $table) {
			$table->foreign('Invoice_id')->references('id')->on('invoices')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('invoice_line_originals', function(Blueprint $table) {
			$table->foreign('ImportedBy_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('insurance_companies', function(Blueprint $table) {
			$table->foreign('Company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('company_employee_uwvdecisions', function(Blueprint $table) {
			$table->foreign('CompanyEmployee_id')->references('id')->on('company_employees')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_CompanyType_id_foreign');
		});
		Schema::table('company_employees', function(Blueprint $table) {
			$table->dropForeign('company_employees_company_id_foreign');
		});
		Schema::table('company_employees', function(Blueprint $table) {
			$table->dropForeign('company_employees_employee_id_foreign');
		});
		Schema::table('communications', function(Blueprint $table) {
			$table->dropForeign('communications_CommunicationType_id_foreign');
		});
		Schema::table('company_employee_employments', function(Blueprint $table) {
			$table->dropForeign('company_employee_employments_CompanyEmployee_id_foreign');
		});
		Schema::table('company_employee_illnesses', function(Blueprint $table) {
			$table->dropForeign('company_employee_illnesses_CompanyEmployee_id_foreign');
		});
		Schema::table('company_employee_illnesses', function(Blueprint $table) {
			$table->dropForeign('company_employee_illnesses_CompanyEmployeeInsurance_id_foreign');
		});
		Schema::table('company_employee_illnesses', function(Blueprint $table) {
			$table->dropForeign('company_employee_illnesses_StatusIllness_id_foreign');
		});
		Schema::table('company_insurances', function(Blueprint $table) {
			$table->dropForeign('company_insurances_Company_id_foreign');
		});
		Schema::table('company_insurances', function(Blueprint $table) {
			$table->dropForeign('company_insurances_InsuredItem_id_foreign');
		});
		Schema::table('company_insurances', function(Blueprint $table) {
			$table->dropForeign('company_insurances_InsuranceCompany_id_foreign');
		});
		Schema::table('company_employee_insurance', function(Blueprint $table) {
			$table->dropForeign('company_employee_insurance_CompanyInsurance_id_foreign');
		});
		Schema::table('company_employee_insurance', function(Blueprint $table) {
			$table->dropForeign('company_employee_insurance_CompanyEmployee_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_Company_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_ImportedByUser_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_ValidatedByUser_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_StatusInvoice_id_foreign');
		});
		Schema::table('invoice_lines', function(Blueprint $table) {
			$table->dropForeign('invoice_lines_Invoice_id_foreign');
		});
		Schema::table('invoice_lines', function(Blueprint $table) {
			$table->dropForeign('invoice_lines_Declaration_id_foreign');
		});
		Schema::table('invoice_lines', function(Blueprint $table) {
			$table->dropForeign('invoice_lines_ValidatedByUser_id_foreign');
		});
		Schema::table('declarations', function(Blueprint $table) {
			$table->dropForeign('declarations_InsuranceCompany_id_foreign');
		});
		Schema::table('declarations', function(Blueprint $table) {
			$table->dropForeign('declarations_ReleasedBy_id_foreign');
		});
		Schema::table('declarations', function(Blueprint $table) {
			$table->dropForeign('declarations_ViewedBy_id_foreign');
		});
		Schema::table('invoice_line_originals', function(Blueprint $table) {
			$table->dropForeign('invoice_line_originals_Invoice_id_foreign');
		});
		Schema::table('invoice_line_originals', function(Blueprint $table) {
			$table->dropForeign('invoice_line_originals_ImportedBy_id_foreign');
		});
		Schema::table('insurance_companies', function(Blueprint $table) {
			$table->dropForeign('insurance_companies_Company_id_foreign');
		});
		Schema::table('company_employee_uwvdecisions', function(Blueprint $table) {
			$table->dropForeign('company_employee_uwvdecisions_CompanyEmployee_id_foreign');
		});
	}
}