<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('area_id')->unsigned();
			$table->string('name', 32);
			$table->string('user_name', 32);
			$table->string('password', 64);
			$table->integer('phone');
			$table->integer('cash_balance');
			$table->integer('winning_balance');
			$table->string('user_type', 32);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}