<?php

namespace App\Models;

class Project extends Eloquent {

	protected $table = 'projects';
	public $timestamps = true;
	protected $fillable = array('title', 'description', 'github_link', 'website_link', 'public', 'image');

	public function skills()
	{
		return $this->belongsToMany('App\Models\Skill', 'skill_project');
	}

	public function users()
	{
		return $this->belongsToMany('App\Models\User', 'project_user');
	}

}