<?php

namespace App\Models;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'password', 'rememper_token', 'cv_file', 'github_link', 'website_link', 'image');

	public function skills()
	{
		return $this->belongsToMany('App\Models\Skill', 'skill_user');
	}

	public function projects()
	{
		return $this->belongsToMany('App\Models\Project', 'project_user');
	}

	public function roles()
	{
		return $this->belongsToMany('App\Models\Role', 'role_user');
	}

}