<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWarehouseProductsTable extends Migration {

	public function up()
	{
		Schema::create('warehouse_products', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('warehouse_id')->unsigned()->index();
			$table->integer('product_id')->unsigned()->index();
			$table->integer('product_variant_map_id')->unsigned()->index();
			$table->bigInteger('opening_stock')->default('0');
			$table->bigInteger('in_stock')->default('0');
			$table->bigInteger('stock_out')->default('0');
			$table->enum('status', array('Active', 'Inactive'))->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('warehouse_products');
	}
}