<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Patient extends Model 
{

    protected $table = 'patients';
    public $timestamps = true;
    protected $fillable = array('name', 'birth_date', 'sex');

    public function bed()
    {
        return $this->hasOne('App\Bed');
    }

    public function doctors()
    {
        return $this->belongsToMany('Doctor');
    }

    public function records()
    {
        return $this->hasMany('App\Record');
    }

}