<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoctorsTable extends Migration {

	public function up()
	{
		Schema::create('doctors', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 100);
			$table->date('birth_date');
			$table->enum('sex', array('male', 'female'));
			$table->string('specialization', 60);
			$table->time('time_in');
			$table->time('time_out');
		});
	}

	public function down()
	{
		Schema::drop('doctors');
	}
}