<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->string('num');
			$table->integer('address_id')->unsigned();
			$table->string('lat');
			$table->string('lng');
			$table->string('map_desc');
			$table->decimal('sub_total', 10,2);
			$table->integer('coupon_id')->unsigned();
			$table->string('coupon_type');
			$table->decimal('coupons_value', 10,2);
			$table->string('coupon_amount');
			$table->decimal('delivery_price', 10,2);
			$table->decimal('vat_value', 10,2);
			$table->string('vat_amount');
			$table->decimal('total', 10,2);
			$table->string('status');
			$table->string('pay_type');
			$table->string('pay_status');
			$table->bigInteger('cancel_reason_id')->nullable();
			$table->morphs('cancelable')->default('user, provider');
			$table->string('cancel_reason');
			$table->text('notes')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}