<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('provider_id');
			$table->bigInteger('sub_category_id');
			$table->enum('type', array('1:basic', '2:multiple'));
			$table->text('name');
			$table->text('description');
			$table->decimal('price', 10, 8)->nullable();
			$table->integer('quantity')->nullable();
			$table->enum('discount_type', array('1:ratio', '2:number', '3:nothing'))->nullable();
			$table->decimal('discount_value', 10, 8)->nullable();
			$table->timestamp('started_discount_at')->nullable();
			$table->timestamp('ended_discount_at')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}