<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProviderPackagesTable extends Migration {

	public function up()
	{
		Schema::create('provider_packages', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('provider_id');
			$table->bigInteger('package_id');
			$table->timestamp('started_at');
			$table->timestamp('ended_at');
			$table->decimal('price', 10, 8);
			$table->tinyInteger('pay_type')->default('0');
			$table->tinyInteger('pay_status')->default('0');
			$table->json('pay_data')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('provider_packages');
	}
}