<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class AdTag extends Eloquent {

	protected $table = 'ad_tag';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('ad_id', 'tag_id');

	public function ad()
	{
		return $this->hasOne('Ad', 'ad_id');
	}

	public function tag()
	{
		return $this->belongsTo('Tag', 'tag_id');
	}

}