<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class AdType extends Eloquent {

	protected $table = 'ad_type';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('ad_id', 'type_id');

	public function ad()
	{
		return $this->belongsTo('Ad', 'ad_id');
	}

	public function type()
	{
		return $this->belongsTo('TagType', 'type_id');
	}

}