<?php

namespace Api;

class CommentReport extends Eloquent {

	protected $table = 'comment_report';
	public $timestamps = true;
	protected $fillable = array('post_id', 'comment_id', 'text', 'created_by');

	public function post()
	{
		return $this->belongsTo('Post', 'post_id');
	}

	public function comment()
	{
		return $this->belongsTo('Comment', 'comment_id');
	}

	public function client()
	{
		return $this->belongsTo('User', 'created_by');
	}

}