<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PostHashtag extends Eloquent {

	protected $table = 'post_hashtag';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('post_id', 'hashtag_id');

	public function post()
	{
		return $this->belongsTo('Post', 'post_id');
	}

}