<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTblSettingOptionTable extends Migration {

	public function up()
	{
		Schema::create('tbl_setting_option', function(Blueprint $table) {
			$table->increments('option_id', true);
			$table->string('option_value', 100);
			$table->string('model_type');
			$table->integer('model_id');
			$table->json('option_properties')->nullable();
			$table->integer('parent_option_id');
			$table->timestamp('option_created');
			$table->timestamp('option_updated');
		});
	}

	public function down()
	{
		Schema::drop('tbl_setting_option');
	}
}