<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTblSettingPicRoleTable extends Migration {

	public function up()
	{
		Schema::create('tbl_setting_pic_role', function(Blueprint $table) {
			$table->increments('pic_role_id', true);
			$table->string('pic_role_name', 100);
			$table->enum('pic_role_type', array('Fleet', 'Vessel'));
			$table->enum('pic_role_status', array('Active', 'Inactive'));
			$table->timestamp('pic_role_created');
			$table->timestamp('pic_role_updated');
			$table->timestamp('pic_role_deleted')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tbl_setting_pic_role');
	}
}